package gui.menus.file;

import gui.GenericLoader;
import gui.MainFrame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;

import service.ServiceFactory;
import service.ServiceFactoryImpl;
import service.SimpleState;
import service.SimpleTransition;
import service.TransitionSystem;
/**
 * @author Andrea
 *
 */
public class RefreshSimulItem extends JMenuItem
{
static final long serialVersionUID = 1l;
	
	public RefreshSimulItem()
	{
		super();
		initialize();
	}
	
	private void initialize()
	{
		this.setText("Refresh Services");
		this.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				if(GenericLoader.orchestratorIsStarted()){
					JOptionPane.showMessageDialog(null,"Stop the simulation before refresh the services","Error", JOptionPane.ERROR_MESSAGE);
					return;
				}
				//refresh services that can be edited
				ServiceFactory sf = new ServiceFactoryImpl();
				Vector<TransitionSystem<SimpleState, SimpleTransition>> tss = new Vector<TransitionSystem<SimpleState, SimpleTransition>>(0,1);
				Vector<String> tssNames = new Vector<String>(0, 1);
				DefaultTableModel availableTableModel=(DefaultTableModel) MainFrame.getInstance().getAvServPanel().getAvailableServiceList().getModel();
				if(GenericLoader.getPathAvailableService().size()>0){
					for(int i = 0; i < GenericLoader.getPathAvailableService().size(); i++)
					{
						try
						{
								TransitionSystem<SimpleState, SimpleTransition> ts=sf.createSimpleTransitionSystem(GenericLoader.getPathAvailableService().elementAt(i));
								tss.addElement(ts);
								tssNames.addElement(ts.getName());
								availableTableModel.setValueAt(ts.getName(), i, 0);								
						}
						catch(Exception exception)
						{
							JOptionPane.showMessageDialog(null,GenericLoader.getPathAvailableService().elementAt(i) + "not loaded: "+exception.getMessage(),"Error", JOptionPane.ERROR_MESSAGE);
							exception.printStackTrace();
						}
					}
					
					GenericLoader.setAvailableServices(tss);
					GenericLoader.setAvailableServicesNames(tssNames);
				}
				if(GenericLoader.getTargetService()!=null){
					try
					{
							TransitionSystem<SimpleState, SimpleTransition> target=sf.createSimpleTransitionSystem(GenericLoader.getPathTarget());
							GenericLoader.setTargetService(target);
							GenericLoader.setTargetServiceName(target.getName());
							DefaultTableModel targetTableModel=(DefaultTableModel) MainFrame.getInstance().getAvServPanel().getTargetServiceList().getModel();
							targetTableModel.setValueAt(target.getName(), 0, 0);
					}
					catch(Exception exception)
					{
						JOptionPane.showMessageDialog(null,GenericLoader.getPathTarget() + "not loaded: "+exception.getMessage(),"Error", JOptionPane.ERROR_MESSAGE);
						System.out.println(exception.getMessage());
					}
				}
				//
				
			}
		});
	}
}
